<?php

// ini_set('error_reporting', E_ALL);
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);

// if($_SERVER['REQUEST_METHOD'] === 'GET' && substr(($_SERVER['HTTP_REFERER'] ?? ''), 0, 26) !== 'https://marfa.wake-app.net') {
//     header("HTTP/1.1 404 Not Found");
//     echo 'File not found.';
//     exit(); 
// }

$valid_passwords = array("pwaadmin" => "Njfn4!dsjn!nVLjs27");
$valid_users = array_keys($valid_passwords);

$user = $_SERVER['PHP_AUTH_USER'];
if (!empty($_GET['user'])) {
    $user = $_GET['user'];
}
$pass = $_SERVER['PHP_AUTH_PW'];
if (!empty($_GET['pass'])) {
    $pass = $_GET['pass'];
}

$validated = (in_array($user, $valid_users)) && ($pass == $valid_passwords[$user]);

if (!$validated) {
  header('WWW-Authenticate: Basic realm="My Realm"');
  header('HTTP/1.0 401 Unauthorized');
  exit();
}

// if($_SERVER['REQUEST_METHOD'] === 'GET' && substr(($_SERVER['HTTP_REFERER'] ?? ''), 0, 26) !== 'https://marfa.wake-app.net') {
//     header("HTTP/1.1 404 Not Found");
//     echo 'use the panel through marfa';
//     exit();
// }

$header = "Authorization: Basic Q0FxYmQ3RTJVU2dQbHJxSDdYX1QySlBMVzRtZm1IOTA6";

function unzip($url, $extractPath, $header) {
  try {
    $opts = array(
      'http'=>array(
        'method'=>"GET",
        'header'=>$header
      )
    );
    $context = stream_context_create($opts);
    $fileContent = file_get_contents($url, false, $context);
    $fileName = 'file.zip';
    if ($fileContent === false) {
        return false;
    }
    if (file_put_contents($extractPath . $fileName, $fileContent) === false) {
        return false;
    }
    $zip = new ZipArchive();
    $zip->open($fileName);
    $result = $zip->extractTo($extractPath);
    if ($result === false) {
        return false;
    }
    $zip->close();
    return true;
  } catch (Exception $e) {
    return false;
  }
}

function diverse_array($vector) {
    $result = array();
    foreach($vector as $key1 => $value1)
        foreach($value1 as $key2 => $value2)
            $result[$key2][$key1] = $value2;
    return $result;
}

function save_file($file, $path, $name) {
    $newPath = $path . $name . "." . pathinfo($file['name'], PATHINFO_EXTENSION);
    if (move_uploaded_file($file['tmp_name'], $newPath)) {
        return $newPath;
    } else {
        return false;
    }
}

function request($url, $method, $header, $data) {
    return file_get_contents($url, null, stream_context_create(array(
        'http' => array(
            'method' => $method,
            'header' => implode("\r\n", $header),
            'content' => json_encode($data)
        )))
    );
}

function merge($data1, $data2) {
  $result = $data1;
  foreach ($data2 as $key => $value) {
    if ($value === "true" || $value === "false") {
      $value = $value === "true";
    }
    $result[$key] = $value;
  }
  return $result;
}

$configData = file_get_contents('./config.json');
if ($configData === false) {
    $configData = array();
    file_put_contents('./config.json', json_encode($configData));
}

$configData = json_decode($configData, true);

$defaultData = json_decode(file_get_contents('./default.json'), true);

if (empty($configData['stream_id'])) {

  $adspectstream = json_decode(request("https://api.adspect.net/v1/streams", "POST", array($header, 'Content-Type: application/json'), array(
    "name" => $_SERVER['HTTP_HOST'],
    "money_pages" => array(
      array(
        "page" => "pagedirect.php",
        "action" => "local",
        "arg_passthru" => true,
        "weight" => 1,
        "enabled" => true
      )
    ),
    "safe_pages" => array(
      array(
        "page" => "",
        "action" => "noop",
        "arg_passthru" => true
      )
    )
  )));
  $configData = merge($configData, $adspectstream);

  $adspectfile = request('https://clients.adspect.ai/getindex.php?name=index&sid=' . $configData['stream_id'], "GET", array("User-Agent: Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36"), array());
  file_put_contents('./index.php', $adspectfile);
  
//   $configData = merge($configData, $defaultData);

  file_put_contents('./config.json', json_encode($configData));

}

function myisset($data) {
    return (isset($data) ? $data : false);
}

if (!empty($_POST) && $_SERVER['REQUEST_METHOD'] == 'POST') {

  $newData = $_POST;

  $newwhite = false;

  if ((myisset($newData['seed']) != myisset($configData['seed']) && !empty($newData['seed'])) ||
      (myisset($newData['product']) != myisset($configData['product']) && !empty($newData['product'])) ||
      (myisset($newData['keywords']) != myisset($configData['keywords'])) ||
      (myisset($newData['target']) != myisset($configData['target']) && !empty($newData['target'])) ||
      (myisset($newData['lang']) != myisset($configData['lang']) && !empty($newData['lang']))) {
        $newwhite = unzip('https://api.comsign.io/v2?product=' . $newData['product'] . '&seed=' . $newData['seed'] . '&keywords=' . rawurlencode($newData['keywords']) . '&target=' . rawurlencode($newData['target']) . '&lang=' . $newData['lang'] . '&domain=' . $_SERVER['HTTP_HOST'] . '&sid=' . $configData['stream_id'] . '&zip=true', './', $header);
  }

  if ($_FILES['iconfile']['error'] === UPLOAD_ERR_OK) {
    $configData['iconpath'] = save_file($_FILES['iconfile'], "./", "icon");
  }
  if (count(diverse_array($_FILES['screenshotsfiles'])) > 0) {
      $configData['screenshotspath'] = [];
      foreach (diverse_array($_FILES['screenshotsfiles']) as $key => $file) {
        if ($file['error'] === UPLOAD_ERR_OK) {
          $configData['screenshotspath'][$key] = save_file($file, "./", "screenshot" . $key);
        }
      }
  }

  if (myisset($newData['mode']) != myisset($configData['mode']) ||
      myisset($newData['filter_level']) != myisset($configData['filter_level']) ||
      myisset($newData['countrieslist']) != myisset($configData['countrieslist']) ||
      myisset($newData['oslist']) != myisset($configData['oslist']) ||
      myisset($newData['browserslist']) != myisset($configData['browserslist']) ||
      myisset($newData['enable_fp']) != myisset($configData['enable_fp']) ||
      myisset($newData['enable_ua']) != myisset($configData['enable_ua']) ||
      myisset($newData['require_unique']) != myisset($configData['require_unique']) ||
      myisset($newData['require_touch']) != myisset($configData['require_touch']) ||
      myisset($newData['allow_apps']) != myisset($configData['allow_apps']) ||
      myisset($newData['tz_match_ip']) != myisset($configData['tz_match_ip']) ||
      myisset($newData['skipClicks']) != myisset($configData['skipClicks']) ||
      myisset($newData['skip_clicks_mode']) != myisset($configData['skip_clicks_mode'])) {
        $adspectstream = json_decode(request("https://api.adspect.net/v1/streams/" . $configData['stream_id'], "PATCH", array($header, 'Content-Type: application/json'), array(
          'mode' => $newData['mode'],
          'filter_level' => $newData['filter_level'],
          'countries' => array_map(function($e) {
              return substr($e['name'], 1, 2);
          }, array_filter(json_decode($newData['countrieslist'], true), function($v) {
            return $v['checked'];
          })),
          'os' => array_map(function($e) {
              return $e['name'];
          }, array_filter(json_decode($newData['oslist'], true), function($v) {
            return $v['checked'];
          })),
          'browsers' => array_map(function($e) {
              return $e['name'];
          }, array_filter(json_decode($newData['browserslist'], true), function($v) {
            return $v['checked'];
          })),
          'enable_fp' => $newData['enable_fp'],
          'enable_ua' => $newData['enable_ua'],
          'require_unique' => $newData['require_unique'],
          'require_touch' => $newData['require_touch'],
          'allow_apps' => $newData['allow_apps'],
          'tz_match_ip' => $newData['tz_match_ip'],
          'skipClicks' => (int)$newData['skipClicks'],
          'skip_clicks_mode' => $newData['skip_clicks_mode']
        )));
  }

  $configData = merge($configData, $newData);

  file_put_contents('./config.json', json_encode($configData));
  
  echo '{ "ok": true, "message": "Данные успешно сохранены" }';
  die();

}

$adspectstream = json_decode(request("https://api.adspect.net/v1/streams/" . $configData['stream_id'], "PATCH", array($header, 'Content-Type: application/json'), array()));
$configData = merge($configData, $adspectstream);
file_put_contents('./config.json', json_encode($configData));

echo '<!doctype html>
<html lang=\'ru\'>

<head>
  <meta charset=\'UTF-8\'>
  <meta name=\'viewport\' content=\'width=device-width, initial-scale=1\'>

  <title>Настройка PWA</title>
  <style>
    * {
      box-sizing: border-box;
    }

    html,
    body {
      height: 100dvh;
      overflow: hidden;
    }

    body {
      font-family: system-ui;
      margin: 0;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
    }

    .wrapper {
      display: flex;
      flex-direction: column;
      gap: 1em;
      width: clamp(200px, 100%, 800px);
      height: 100dvh;
      overflow-y: scroll;
    }

    .wrapper:after {
      content: \'\';
      min-height: 3em;
    }

    .block {
      display: flex;
      flex-direction: column;
      margin: 0 0.5em;
      gap: .5em;
      width: -moz-available;
      width: -webkit-fill-available;
      width: fill-available;
    }

    .horizontal {
      flex-direction: row;
    }

    .buttons {
      display: flex;
      flex-direction: row;
      justify-content: space-between;
      position: sticky;
      padding: 0.5em;
      top: 0;
      backdrop-filter: blur(4px);
      z-index: 10;
    }

    button,
    .button {
      border-radius: 2em;
      border: none;
      background: #3a4aa7;
      color: white;
      font-size: 0.8em;
      display: flex;
      flex-direction: row;
      align-content: center;
      justify-content: center;
      align-items: center;
    }

    button {
      padding: .5em;
    }

    button#save:disabled:after,
    button#generate:disabled:after {
      content: \'\';
      width: 1.5em;
      height: 1em;
      background-repeat: no-repeat;
      background-position: center right;
      background-size: 1em;
      background-image: url("data:image/svg+xml,%3Csvg stroke=\'%23fff\' viewBox=\'0 0 24 24\' xmlns=\'http://www.w3.org/2000/svg\'%3E%3Cstyle%3E.spinner_V8m1%7Btransform-origin:center;animation:spinner_zKoa 2s linear infinite%7D.spinner_V8m1 circle%7Bstroke-linecap:round;animation:spinner_YpZS 1.5s ease-in-out infinite%7D@keyframes spinner_zKoa%7B100%25%7Btransform:rotate(360deg)%7D%7D@keyframes spinner_YpZS%7B0%25%7Bstroke-dasharray:0 150;stroke-dashoffset:0%7D47.5%25%7Bstroke-dasharray:42 150;stroke-dashoffset:-16%7D95%25,100%25%7Bstroke-dasharray:42 150;stroke-dashoffset:-59%7D%7D%3C/style%3E%3Cg class=\'spinner_V8m1\'%3E%3Ccircle cx=\'12\' cy=\'12\' r=\'9.5\' fill=\'none\' stroke-width=\'3\'%3E%3C/circle%3E%3C/g%3E%3C/svg%3E");
    }

    .button>input[type="checkbox"] {
      visibility: hidden;
      position: absolute;
    }

    .button:has(input[type="checkbox"]:checked) {
      background: #3aa74a;
    }

    button:hover,
    .button:hover {
      filter: brightness(1.2);
    }

    button:active,
    .button:active {
      filter: brightness(1.4);
    }

    button:disabled {
      filter: grayscale(1);
    }

    input[type="text"],
    input[inputmode="numeric"],
    textarea,
    select {
      font-family: system-ui;
      border-radius: .5em;
      border: solid 1px black;
      padding: .5em;
    }

    textarea {
      resize: none;
    }

    .imageblock {
      width: 100%;
      border-radius: 16%;
      aspect-ratio: 1;
      background: #e3e3e3;
      flex: none;
      display: flex;
      /*   justify-content: center; */
      align-items: center;
      color: white;
      text-align: center;
      gap: 4px;
      background-size: contain;
      background-repeat: no-repeat;
      background-position: center;
    }

    .slider {
      --x: 6;
      display: grid;
      grid-template-columns: repeat(auto-fill, calc((100% - (0.5em * (var(--x) - 1))) / var(--x)));
      grid-gap: .5em;
      justify-content: space-between;
    }

    .slider.screenshots {
      --x: 3;
    }

    @media (width < 640px) {
      .slider {
        --x: 5;
      }

      .slider.screenshots {
        --x: 2;
      }
    }

    @media (width < 420px) {
      .slider {
        --x: 4;
      }

      .slider.screenshots {
        --x: 1;
      }
    }

    .slider>label:last-child>.imageblock {
      background-image: url("data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1920 1920\' fill=\'none\'%3E%3Cpath d=\'M920 1120V794L816 898L760 840L960 640L1160 840L1104 898L1000 794V1120H920ZM720 1280C698 1280 679.167 1272.17 663.5 1256.5C647.833 1240.83 640 1222 640 1200V1080H720V1200H1200V1080H1280V1200C1280 1222 1272.17 1240.83 1256.5 1256.5C1240.83 1272.17 1222 1280 1200 1280H720Z\' fill=\'black\'/%3E%3C/svg%3E");
      background-position: center;
      background-repeat: no-repeat;
      background-size: contain;
    }

    .slider>label>.imageblock:has(img) {
      background: white;
    }

    .slider>label:last-child>.imageblock:has(img) {
      background: white;
    }

    .slider>label>input[type="radio"] {
      visibility: hidden;
      position: absolute;
    }

    .slider>label>input[type="radio"]+div {
      cursor: pointer;
    }

    .slider>label>input[type="radio"]:checked+div {
        border: 0.25em solid #ff0000;
        transform: scale(1.125);
        position: relative;
        z-index: 1;
    }
    
    .slider.screenshots>label>input[type="radio"]:checked+div {
        border: 0.25em solid #ff0000;
        transform: scale(1.025);
        position: relative;
        z-index: 1;
    }

    .slider~input[type="file"] {
      display: none;
    }

    .slider:has(label:last-child > input[type="radio"]:checked)~input[type="file"] {
      display: block;
    }

    .slider.screenshots .imageblock {
      border-radius: 0%;
      aspect-ratio: 3/2;
      overflow-x: scroll;
      overflow-y: hidden;
    }

    .slider .imageblock img,
    .slider .imageblock picture {
      height: 100%;
    }

    .optional {
      display: none;
    }

    .wrapper:has(input#additionalsettings[type="checkbox"]:checked) .optional {
      display: flex;
    }

    input:invalid,
    textarea:invalid {
      background-color: lightpink;
    }

    input[type="range"] {
      position: relative;
      margin-left: 1.5em;
      width: calc(100% - 1.5em);
    }

    input[type="range"]:after {
      content: attr(data-value);
      position: absolute;
      left: -1.5em;
    }

    div.review {
      counter-increment: review;
    }

    div.review:before {
      content: counter(review) ". ";
    }

    .review {
      display: flex;
      flex-direction: row;
      width: 100%;
    }

    hr {
      margin: 0;
    }

    :root {
      --background-color: #fff;
      --foreground-color: #222;
      --accent-color: #608bbf;
      --background-gray: #80808030;
      --foreground-gray: #808080d0;
    }

    .group {
      width: 100%;
      border-radius: 0.5em;
      border: solid 1px black;
      position: relative;
      padding: 0.5em;
      cursor: text;
      font-size: .8333em;
    }

    .opts {
      width: 100%;
      font-size: 1em;
      display: block;
      border: none;
      resize: none;
      outline: none;
      overflow: hidden;
    }

    .opts {
      display: flex;
      flex-direction: row;
      align-items: center;
      gap: 0.5em;
      flex-wrap: wrap;
    }

    .opts>span {
      cursor: pointer;
    }

    .opts:has(textarea) {
      padding: 0;
    }

    .opts>input {
      padding: 0;
      min-width: 100px;
      flex: 1;
      background: none;
      border: none;
      font-size: 1em;
      outline: none;
      overflow: hidden;
    }

    .multiselect>.opts>input {
      padding: 0;
      min-width: 100px;
      flex: 1;
      min-height: 1em;
      font-style: italic;
      background: none;
      border: none;
      font-size: 1em;
      outline: none;
      overflow: hidden;
    }

    .autocomplete-items>div {
      display: flex;
      flex-direction: row;
      gap: 0.5em;
      align-items: center;
    }

    .autocomplete-items>div>input[type="checkbox"] {
      width: 1.15em;
      height: 1.15em;
    }

    .autocomplete {
      position: relative;
      display: inline-block;
    }

    .autocomplete-items {
      position: absolute;
      border: 1px solid black;
      z-index: 9;
      top: 100%;
      left: 0;
      right: 0;
      max-height: 30dvh;
      overflow-y: auto;
      border-radius: 0.5em;
    }

    .autocomplete-items:not(:has(.item:not(.hidden))) {
      display: none;
    }

    .autocomplete-items div {
      padding: 0.5em;
      cursor: pointer;
      background-color: var(--background-color);
      border-bottom: 1px solid var(--background-gray);
    }

    .autocomplete-items div:hover {
      filter: brightness(0.8);
    }

    div.autocomplete-active,
    div.autocomplete-active:hover {
      background: var(--accent-color);
      color: var(--background-color);
      filter: none;
    }

    .checkall {
      font-weight: bold;
    }

    .column {
      display: flex;
      flex-direction: column;
      gap: 0.5em;
      width: 100%;
    }

    .row {
      display: flex;
      flex-direction: row;
      gap: 0.5em;
      align-items: center;
    }

    .bottom {
      text-align: center;
      font-size: 0.85em;
    }

    .fill {
      justify-content: space-between;
    }

    .hug {
      justify-content: normal;
    }

    .start {
      justify-content: start;
    }

    .end {
      justify-content: end;
    }

    div.hidden {
      display: none;
    }

    #notifications {
      position: absolute;
      bottom: 0.5em;
      right: 0.5em;
      display: flex;
      flex-direction: column;
      gap: 0.5em;
    }

    #notifications>span {
      display: block;
      max-width: 300px;
      background: var(--foreground-color);
      color: var(--background-color);
      padding: 0.875em;
      border-radius: 0.25em;
      /*         animation: fade-out 1.1s ease 3; */
    }

    @keyframes fade-out {
      0% {
        filter: opacity(1);
      }

      100% {
        filter: opacity(0);
      }
    }

    ::backdrop {
      backdrop-filter: blur(12px);
      background: url("data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' width=\'32\' height=\'32\' viewBox=\'0 0 32 32\' fill=\'none\'%3E%3Crect x=\'8\' y=\'11.2\' width=\'4.52548\' height=\'18.1019\' transform=\'rotate(-45 8 11.2)\' fill=\'black\'/%3E%3Crect x=\'20.8\' y=\'8\' width=\'4.52548\' height=\'18.1019\' transform=\'rotate(45 20.8 8)\' fill=\'black\'/%3E%3C/svg%3E"),
        rgb(255 255 255 / 0.1);
      background-repeat: no-repeat;
      background-position-x: right;
      background-size: 48px;
    }

    #requests:empty {
      height: 2rem;
      background-image: url("data:image/svg+xml,%3Csvg stroke=\'%23000\' viewBox=\'0 0 24 24\' xmlns=\'http://www.w3.org/2000/svg\'%3E%3Cstyle%3E.spinner_V8m1%7Btransform-origin:center;animation:spinner_zKoa 2s linear infinite%7D.spinner_V8m1 circle%7Bstroke-linecap:round;animation:spinner_YpZS 1.5s ease-in-out infinite%7D@keyframes spinner_zKoa%7B100%25%7Btransform:rotate(360deg)%7D%7D@keyframes spinner_YpZS%7B0%25%7Bstroke-dasharray:0 150;stroke-dashoffset:0%7D47.5%25%7Bstroke-dasharray:42 150;stroke-dashoffset:-16%7D95%25,100%25%7Bstroke-dasharray:42 150;stroke-dashoffset:-59%7D%7D%3C/style%3E%3Cg class=\'spinner_V8m1\'%3E%3Ccircle cx=\'12\' cy=\'12\' r=\'9.5\' fill=\'none\' stroke-width=\'3\'%3E%3C/circle%3E%3C/g%3E%3C/svg%3E");
      background-repeat: no-repeat;
      background-position-x: center;
      background-position-y: center;
      background-size: 2rem;
    }

    dialog {
      min-width: clamp(200px, calc(100dvw - 1em), 1200px);
      border-radius: 8px;
      top: 29px;
      max-height: calc(100dvh - 67px);
      min-height: 80dvh;
    }


    label {
      text-wrap: balance;
    }

    .generator {
      flex-direction: row;
    }

    @media (width < 640px) {
      .generator {
        flex-direction: column;
      }
    }

    .output>img {
      width: 100%;
    }
  </style>
</head>

<body class="home blog hfeed">
  <div class="wrapper">
    <div class="buttons">
      <div class="button"><input type="checkbox" id="additionalsettings" name="additionalsettings"
          value="additionalsettings">
        <label for="additionalsettings" style="padding: .5em;">Расширенные настройки</label>
      </div>
      <button id="save">Сохранить</button>
    </div>
    <div class="block">
      <label for="link">Ссылка оффера/кампании</label>
      <textarea id="link" placeholder="' . $defaultData['link'] . '" rows="1">' . htmlspecialchars($configData['link'] ?? '') . '</textarea>
    </div>
    <div class="block">
      <label for="title">Название</label>
      <small>Используйте макрос <mark onclick="navigator.clipboard.writeText(\'{title}\'); addNotification(\'Текст {title} скопирован в буфер обмена\');" style="cursor: pointer;">{title}</mark> для подстановки названия в тексты описания, обновления и отзывов</small>
      <textarea id="title" maxlength="50" placeholder="' . $defaultData['title'] . '" rows="1">' . htmlspecialchars($configData['title'] ?? '') . '</textarea>
    </div>
    <div class="block optional">
      <label for="subtitle">Подзаголовок (для iOS)</label>
      <textarea id="subtitle" maxlength="30" placeholder="' . $defaultData['subtitle'] . '" rows="1">' . htmlspecialchars($configData['subtitle'] ?? '') . '</textarea>
    </div>
    <div class="block optional">
      <label for="shortdescription">Короткое описание (для Android)</label>
      <textarea id="shortdescription" maxlength="80" rows="2">' . htmlspecialchars($configData['shortdescription'] ?? '') . '</textarea>
    </div>
    <div class="block">
      <label for="description">Описание</label>
      <textarea id="description" maxlength="4000" placeholder="' . $defaultData['description'] . '" rows="6">' . htmlspecialchars($configData['description'] ?? '') . '</textarea>
    </div>
    <div class="block optional">
      <label for="updatetext">Текст обновления</label>
      <textarea id="updatetext" maxlength="500" placeholder="" rows="4">' . htmlspecialchars($configData['updatetext'] ?? '') . '</textarea>
    </div>
    <div class="block horizontal optional">
      <input type="checkbox" id="translatetexts" ' . ($configData['translatetexts'] ?? true ? 'checked' : '') . '></input>
      <label for="translatetexts">Переводить страницу</label>
    </div>
    <div class="block horizontal optional">
      <input type="checkbox" id="translatetitle" ' . ($configData['translatetitle'] ?? false ? 'checked' : '') . '></input>
      <label for="translatetitle">Переводить название</label>
    </div>
    <div class="block horizontal optional">
      <input type="checkbox" id="translatedevelopername" ' . ($configData['translatedevelopername'] ?? false ? 'checked' : '') . '></input>
      <label for="translatedevelopername">Переводить имя разработчика</label>
    </div>
    <div class="block horizontal optional">
      <input type="checkbox" id="translatereviewsnames" ' . ($configData['translatereviewsnames'] ?? false ? 'checked' : '') . '></input>
      <label for="translatereviewsnames">Переводить имена пользователей в отзывах</label>
    </div>
    <div class="block">
      <label for="icon">Иконка</label>
      <div class="slider">';
if (empty($configData["icon"])) {
  $configData["icon"] = 0;
}
for ($i = 0; $i < 52; $i++) {      
    echo '<label>
      <input type="radio" id="icon' . $i . '" name="iconimage" value="' . $i . '" ' . (((int)$configData["icon"] === $i) ? 'checked' : '') . ' />
      <div class="imageblock" style="background-image: image-set( url(\'https://dnacont.com/icon/' . $i . '.avif\') type(\'image/avif\'), url(\'https://dnacont.com/icon/' . $i . '.png\') type(\'image/png\') )"></div>
    </label>';
}
echo '<label>
          <input type="radio" id="icon52" name="iconimage" value="52" ' . (((int)$configData["icon"] === 52) ? 'checked' : '') . ' />
          <div class="imageblock" ' . (($configData['iconpath'] ?? false) ? ('style="background-image: url(' . $configData['iconpath'] . ')">') : '>') . '</div>
        </label>
      </div>
      <input type="file" accept="image/*" id="iconinput"></input>
    </div>
    <div class="block">
      <label for="screenshots">Скриншоты (не более 8 штук)</label>
      <div class="slider screenshots">';
if (empty($configData["screenshots"])) {
  $configData["screenshots"] = 0;
}
for ($i = 0; $i < 23; $i++) {      
    echo '<label>
      <input type="radio" id="screenshots' . $i . '" name="screenshotsimage" value="' . $i . '" ' . (((int)$configData["screenshots"] === $i) ? 'checked' : '') . ' />
      <div class="imageblock">';
      for ($j = 1; $j < 9; $j++) {
        echo '<picture><source srcset="https://dnacont.com/screenshots/' . $i . '/0' . $j . '.avif" type="image/avif"><img src="https://dnacont.com/screenshots/' . $i . '/0' . $j . '.png" loading="lazy"></picture>';
      }
    echo '</div></label>';
}
echo '
        <label>
          <input type="radio" id="screenshots23" name="screenshotsimage" value="23" ' . (((int)$configData["screenshots"] === 23) ? 'checked' : '') . ' />
          <div class="imageblock">';
if (isset($configData['screenshotspath'])) {
    foreach ($configData['screenshotspath'] as $key => $value) {
      echo !empty($value) ? '<img src="' . $value . '">' : '';
    }
}
echo '</div>
        </label>
      </div>
      <input type="file" accept="image/*" id="screenshotsinput" multiple></input>
    </div>
    <div class="block optional">
      <label for="video">Ссылка на Youtube для добавления видео в АСО</label>
      <textarea id="video" placeholder=\'https://www.youtube.com/watch?v=\' rows="1">' . htmlspecialchars($configData['video'] ?? '') . '</textarea>
    </div>
    <div class="block optional">
      <label for="category">Категории (через запятую)</label>
      <textarea id="category" placeholder="' . $defaultData['category'] . '" rows="1">' . htmlspecialchars($configData['category'] ?? '') . '</textarea>
    </div>
    <div class="block optional">
      <label for="developername">Имя разработчика</label>
      <textarea id="developername" maxlength="30" placeholder="' . $defaultData['developername'] . '" rows="1">' . htmlspecialchars($configData['developername'] ?? '') . '</textarea>
    </div>
    <div class="block optional">
      <label for="installscount">Количество установок</label>
      <input inputmode="numeric" pattern="[0-9]*" id="installscount" placeholder="' . $defaultData['installscount'] . '" value="' . htmlspecialchars($configData['installscount'] ?? '') . '"></input>
    </div>
    <div class="block optional">
      <label for="agebasedrating">Возрастной рейтинг приложения</label>
      <input inputmode="numeric" pattern="[0-9]{1,2}" id="agebasedrating" placeholder="' . $defaultData['agebasedrating'] . '" value="' . htmlspecialchars($configData['agebasedrating'] ?? '') . '"></input>
    </div>
    <div class="block optional">
      <label for="averagerating">Оценка приложения</label>
      <input inputmode="numeric" pattern="[0-5]{1}([\.][0-9]{1})*" id="averagerating" placeholder="' . $defaultData['averagerating'] . '" value="' . htmlspecialchars($configData['averagerating'] ?? '') . '"></input>
    </div>
    <div class="block optional">
      <label for="ratingscount">Количество оценок</label>
      <input inputmode="numeric" pattern="[0-9]*" id="ratingscount" placeholder="' . $defaultData['ratingscount'] . '" value="' . htmlspecialchars($configData['ratingscount'] ?? '') . '"></input>
    </div>
    <div class="block optional">
      <label for="reviewscount">Количество отзывов</label>
      <input type="range" min="0" max="25" step="1" oninput="this.dataset.value=this.value" value="' . ($configData['reviewscount'] ?? 10) . '" data-value="' . ($configData['reviewscount'] ?? 10) . '" id="reviewscount" />
    </div>
    <details class="block optional">
      <summary>Отзывы</summary>
      <div class="block">';
for ($i = 0; $i < 25; $i++) {
    echo '<div class="review">
      <div class="block">
        <div class="block optional">
          <label for="reviewname' . $i . '">Имя пользователя</label>
          <textarea id="reviewname' . $i . '" maxlength="30" placeholder="' . htmlspecialchars(json_decode($defaultData['reviews'], true)[$i]['name']) . '" rows="1">' . htmlspecialchars(json_decode($configData['reviews'], true)[$i]['name'] ?? '') . '</textarea>
        </div>
        <div class="block optional">
          <label for="reviewgrade' . $i . '">Оценка</label>
          <input type="range" min="1" max="5" step="1" oninput="this.dataset.value=this.value" value="' . (json_decode($configData['reviews'], true)[$i]['grade'] ?? htmlspecialchars(json_decode($defaultData['reviews'], true)[$i]['grade'])) . '" data-value="' . (json_decode($configData['reviews'], true)[$i]['grade'] ?? htmlspecialchars(json_decode($defaultData['reviews'], true)[$i]['grade'])) . '" id="reviewgrade' . $i . '" />
        </div>
        <div class="block optional">
          <label for="reviewtitle' . $i . '">Заголовок отзыва (для iOS)</label>
          <textarea id="reviewtitle' . $i . '" maxlength="50" placeholder="' . htmlspecialchars(json_decode($defaultData['reviews'], true)[$i]['title']) . '" rows="1">' . htmlspecialchars(json_decode($configData['reviews'], true)[$i]['title'] ?? '') . '</textarea>
        </div>
        <div class="block optional">
          <label for="reviewtext' . $i . '">Текст отзыва</label>
          <textarea id="reviewtext' . $i . '" maxlength="500" placeholder="' . htmlspecialchars(json_decode($defaultData['reviews'], true)[$i]['text']) . '" rows="4">' . htmlspecialchars(json_decode($configData['reviews'], true)[$i]['text'] ?? '') . '</textarea>
        </div>
      </div>
    </div>';
}
echo '</div>
    </details>
    <div class="block optional">
      <label for="headcode"><span>Кастомный код в </span><span>
          <</span><span>head</span><span>></span></label>
      <textarea id="headcode" rows="6">' . htmlspecialchars($configData['headcode'] ?? '') . '</textarea>
    </div>
    <div class="block optional">
      <label for="bodycode"><span>Кастомный код в </span><span>
          <</span><span>body</span><span>></span></label>
      <textarea id="bodycode" rows="6">' . htmlspecialchars($configData['bodycode'] ?? '') . '</textarea>
    </div>
    <div class="block optional">
      <label for="onesignalappid">OneSignal App ID</label>
      <textarea id="onesignalappid" rows="1" placeholder="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx">' . htmlspecialchars($configData['onesignalappid'] ?? '') . '</textarea>
    </div>
    <div class="block">
      <label>Клоака</label>
      <div class="block">
        <div class="block">
          <label for="mode">Режим потока <a target="blank"
              href="https://docs.adspect.ai/ru/latest/streams.html#id5">ⓘ</a></label>
          <select name="mode" id="mode">';
$modes = array(
    array(
        "name" => "Фильтр",
        "value" => "Filter"
    ),
    array(
        "name" => "Модерация",
        "value" => "Review"
    ),
    array(
        "name" => "Контент",
        "value" => "Money"
    ),
    array(
        "name" => "Белая страница",
        "value" => "White"
    )
);
foreach ($modes as $value) {
    echo '<option value="' . $value["value"] . '" ' . (($configData["mode"] === $value["value"]) ? 'selected' : '') . '>' . $value["name"] . '</option>';
}
echo'</select>
        </div>
        <div class="block">
          <label for="filter_level">Уровень фильтрации <a target="blank"
              href="https://docs.adspect.ai/ru/latest/streams.html#id22">ⓘ</a></label>
          <select name="filter_level" id="filter_level">';
$filterlevels = array(
    array(
        "name" => "Минимальный",
        "value" => 0
    ),
    array(
        "name" => "Низкий",
        "value" => 1
    ),
    array(
        "name" => "Средний",
        "value" => 2
    ),
    array(
        "name" => "Высокий",
        "value" => 3
    ),
    array(
        "name" => "Паранойя",
        "value" => 4
    )
);
foreach ($filterlevels as $value) {
    echo '<option value="' . $value["value"] . '" ' . (($configData["filter_level"] === $value["value"]) ? 'selected' : '') . '>' . $value["name"] . '</option>';
}
echo'</select>
        </div>
        <div class="block">
          <label for="countries">Разрешенные страны</label>
          <div name="countries" id="countries"></div>
        </div>
        <div class="block">
          <label for="os">Разрешенные операционные системы</label>
          <div name="os" id="os"></div>
        </div>
        <div class="block">
          <label for="browsers">Разрешенные браузеры</label>
          <div name="browsers" id="browsers"></div>
        </div>
        <div class="block horizontal optional">
          <input type="checkbox" id="enable_fp" ' . (($configData["enable_fp"]) ? 'checked' : '') . '></input>
          <label for="enable_fp">Включить фильтрацию по JavaScript-отпечаткам <a target="blank"
              href="https://docs.adspect.ai/ru/latest/streams.html#javascript-vla">ⓘ</a></label>
        </div>
        <div class="block horizontal optional">
          <input type="checkbox" id="enable_ua" ' . (($configData["enable_ua"]) ? 'checked' : '') . '></input>
          <label for="enable_ua">Включить фильтрацию по встроенным спискам user agent <a target="blank"
              href="https://docs.adspect.ai/ru/latest/streams.html#user-agent">ⓘ</a></label>
        </div>
        <div class="block horizontal optional">
          <input type="checkbox" id="require_unique" ' . (($configData["require_unique"]) ? 'checked' : '') . '></input>
          <label for="require_unique">Пропускать только уникальных посетителей <a target="blank"
              href="https://docs.adspect.ai/ru/latest/streams.html#id23">ⓘ</a></label>
        </div>
        <div class="block horizontal optional">
          <input type="checkbox" id="require_touch" ' . (($configData["require_touch"]) ? 'checked' : '') . '></input>
          <label for="require_touch">Требовать поддержку touchscreen <a target="blank"
              href="https://docs.adspect.ai/ru/latest/streams.html#touchscreen">ⓘ</a></label>
        </div>
        <div class="block horizontal optional">
          <input type="checkbox" id="allow_apps" ' . (($configData["allow_apps"]) ? 'checked' : '') . '></input>
          <label for="allow_apps">Разрешить трафик из мобильных приложений <a target="blank"
              href="https://docs.adspect.ai/ru/latest/streams.html#id24">ⓘ</a></label>
        </div>
        <div class="block horizontal optional">
          <input type="checkbox" id="tz_match_ip" ' . (($configData["tz_match_ip"]) ? 'checked' : '') . '></input>
          <label for="tz_match_ip">Проверять соответствие часового пояса браузера и местоположения <a target="blank"
              href="https://docs.adspect.ai/ru/latest/streams.html#id32">ⓘ</a></label>
        </div>
        <div class="block optional">
          <label>Отложенный запуск <a target="blank"
              href="https://docs.adspect.ai/ru/latest/streams.html#id25">ⓘ</a></label>
          <div class="block">
            <label for="skipClicks">Число первых переходов, которые будут отфильтрованы</label>
            <input inputmode="numeric" pattern="[0-9]*" id="skipClicks" placeholder="10" value="' . htmlspecialchars($configData['skipClicks'] ?? '') . '"></input>
          </div>
          <div class="block">
            <label for="skip_clicks_mode">Режим пропуска переходов</label>
            <select name="skip_clicks_mode" id="skip_clicks_mode">';
$skipckicksmodes = array(
    array(
        "name" => "Все: счетчик пропущенных переходов уменьшается при каждом переходе",
        "value" => "all"
    ),
    array(
        "name" => "Контент: счетчик переходов уменьшается с каждым легитимным посетителем",
        "value" => "money"
    ),
    array(
        "name" => "Белая: счетчик переходов уменьшается с каждым ботом, модератором и т.п.",
        "value" => "safe"
    )
);
foreach ($skipckicksmodes as $value) {
    echo '<option value="' . $value["value"] . '" ' . (($configData["skip_clicks_mode"] === $value["value"]) ? 'selected' : '') . '>' . $value["name"] . '</option>';
}
echo '</select>
          </div>
        </div>
        <div class="block">
          <button onclick="this.parentNode.querySelector(\'dialog\').showModal()">Генерация вайта</button>
          <dialog>
            <div class="block">
              <div class="buttons">
                <div></div>
                <button id="generate">Предпросмотр</button>
              </div>
              <div class="block generator">
                <div class="block">
                  <div class="block">
                    <label for="product">Тип вайта <a target="blank"
                        href="https://docs.adspect.ai/ru/latest/comsign.html#id1">ⓘ</a></label>
                    <select name="product" id="product">';
$products = array(
    array(
        "name" => "WordPress",
        "value" => "wp"
    ),
    array(
        "name" => "Новостной блог",
        "value" => "sf"
    ),
    array(
        "name" => "Google Play",
        "value" => "gp"
    ),
    array(
        "name" => "App Store",
        "value" => "ap"
    ),
    array(
        "name" => "Копирование сайтов",
        "value" => "sc"
    )
);
foreach ($products as $value) {
    echo '<option value="' . $value["value"] . '" ' . (($configData["product"] === $value["value"]) ? 'selected' : '') . '>' . $value["name"] . '</option>';
}
echo '</select>
                  </div>
                  <div class="block">
                    <label for="target">Тема для WordPress или новостного блога / ссылка на Google Play, App Store или
                      сайт для копирования</label>
                    <div id="target"></div>
                  </div>
                  <div class="block">
                    <label for="lang">Язык вайта</label>
                    <select name="lang" id="lang">';
$langs = array(
    array( "name" => "Азербайджанский", "value" => "az_AZ"),
    array( "name" => "Английский", "value" => "en_US"),
    array( "name" => "Арабский", "value" => "ar_SA"),
    array( "name" => "Армянский", "value" => "hy_AM"),
    array( "name" => "Африкаанс", "value" => "af_ZA"),
    array( "name" => "Белорусский", "value" => "be_BY"),
    array( "name" => "Бенгальский", "value" => "bn_BD"),
    array( "name" => "Болгарский", "value" => "bg_BG"),
    array( "name" => "Венгерский", "value" => "hu_HU"),
    array( "name" => "Вьетнамский", "value" => "vi_VN"),
    array( "name" => "Греческий", "value" => "el_GR"),
    array( "name" => "Грузинский", "value" => "ka_GE"),
    array( "name" => "Датский", "value" => "da_DK"),
    array( "name" => "Иврит", "value" => "he_IL"),
    array( "name" => "Индонезийский", "value" => "id_ID"),
    array( "name" => "Ирландский", "value" => "ga_IE"),
    array( "name" => "Исландский", "value" => "is_IS"),
    array( "name" => "Испанский", "value" => "es_ES"),
    array( "name" => "Итальянский", "value" => "it_IT"),
    array( "name" => "Казахский", "value" => "kk_KZ"),
    array( "name" => "Китайский", "value" => "zh_CH"),
    array( "name" => "Корейский", "value" => "ko_KR"),
    array( "name" => "Латвийский", "value" => "lv_LV"),
    array( "name" => "Литовский", "value" => "lt_LT"),
    array( "name" => "Македонский", "value" => "mk_MK"),
    array( "name" => "Малайский", "value" => "ms_MY"),
    array( "name" => "Монгольский", "value" => "mn_MN"),
    array( "name" => "Немецкий", "value" => "de_DE"),
    array( "name" => "Нидерландский", "value" => "nl_NL"),
    array( "name" => "Польский", "value" => "pl_PL"),
    array( "name" => "Норвежский", "value" => "no_NO"),
    array( "name" => "Португальский", "value" => "pt_PT"),
    array( "name" => "Румынский", "value" => "ro_RO"),
    array( "name" => "Русский", "value" => "ru_RU"),
    array( "name" => "Сербский", "value" => "sr_RS"),
    array( "name" => "Словацкий", "value" => "sk_SK"),
    array( "name" => "Словенский", "value" => "sl_SL"),
    array( "name" => "Тайский", "value" => "th_TH"),
    array( "name" => "Турецкий", "value" => "tr_TR"),
    array( "name" => "Украинский", "value" => "uk_UA"),
    array( "name" => "Финский", "value" => "fi_FI"),
    array( "name" => "Французский", "value" => "fr_FR"),
    array( "name" => "Хинди", "value" => "hi_IN"),
    array( "name" => "Хорватский", "value" => "hr_HR"),
    array( "name" => "Чешский", "value" => "cs_CZ"),
    array( "name" => "Шведский", "value" => "sv_SE"),
    array( "name" => "Эстонский", "value" => "et_EE"),
    array( "name" => "Японский", "value" => "ja_JP")
);
if (empty($configData["lang"])) {
    $configData["lang"] = "en_US";
}
foreach ($langs as $value) {
    echo '<option value="' . $value["value"] . '" ' . (($configData["lang"] === $value["value"]) ? 'selected' : '') . '>' . $value["name"] . '</option>';
}
echo '</select>
                  </div>
                  <div class="block">
                    <label for="keywords">Ключевые слова для встраивания в код вайта (через запятую)</label>
                    <textarea id="keywords" placeholder=\'\' rows="1">' . htmlspecialchars($configData['keywords'] ?? '') . '</textarea>
                  </div>
                  <div class="block">
                    <label for="seed">Сид генерации</label>
                    <textarea id="seed" placeholder=\'\' rows="1" disabled>' . htmlspecialchars($configData['seed'] ?? '') . '</textarea>
                  </div>
                </div>
                <div class="block output" id="output">

                </div>
              </div>
            </div>
          </dialog>
        </div>
      </div>
    </div>
  </div>
  <div id="notifications"></div>
  <script>
    const save = document.querySelector("#save");

    const link = document.querySelector("#link");
    const title = document.querySelector("#title");
    const subtitle = document.querySelector("#subtitle");
    const shortdescription = document.querySelector("#shortdescription");
    const description = document.querySelector("#description");
    const updatetext = document.querySelector("#updatetext");
    const translatetexts = document.querySelector("#translatetexts");
    const translatetitle = document.querySelector("#translatetitle");
    const translatedevelopername = document.querySelector("#translatedevelopername");
    const translatereviewsnames = document.querySelector("#translatereviewsnames");

    const video = document.querySelector("#video");
    const category = document.querySelector("#category");
    const developername = document.querySelector("#developername");
    const installscount = document.querySelector("#installscount");
    const agebasedrating = document.querySelector("#agebasedrating");
    const averagerating = document.querySelector("#averagerating");
    const ratingscount = document.querySelector("#ratingscount");
    const reviewscount = document.querySelector("#reviewscount");

    let reviews = [];
    for (let i = 0; i < 25; i++) {
      reviews.push({
        "name": document.querySelector(`#reviewname${i}`),
        "grade": document.querySelector(`#reviewgrade${i}`),
        "title": document.querySelector(`#reviewtitle${i}`),
        "text": document.querySelector(`#reviewtext${i}`)
      });
    }

    const headcode = document.querySelector("#headcode");
    const bodycode = document.querySelector("#bodycode");
    const onesignalappid = document.querySelector("#onesignalappid");

    const mode = document.querySelector("#mode");
    const filter_level = document.querySelector("#filter_level");
    const countries = document.querySelector("#countries");
    const os = document.querySelector("#os");
    const enable_fp = document.querySelector("#enable_fp");
    const enable_ua = document.querySelector("#enable_ua");
    const require_unique = document.querySelector("#require_unique");
    const require_touch = document.querySelector("#require_touch");
    const allow_apps = document.querySelector("#allow_apps");
    const tz_match_ip = document.querySelector("#tz_match_ip");

    const skipClicks = document.querySelector("#skipClicks");
    const skip_clicks_mode = document.querySelector("#skip_clicks_mode");

    const generate = document.querySelector("#generate");

    const product = document.querySelector("#product");
    const target = document.querySelector("#target");
    const lang = document.querySelector("#lang");
    const keywords = document.querySelector("#keywords");
    const seed = document.querySelector("#seed");

    const output = document.querySelector("#output");

    const iconinput = document.querySelector("#iconinput");
    const screenshotsinput = document.querySelector("#screenshotsinput");

    const iconoutput = document.querySelector(".slider > label:last-child > .imageblock");
    const screenshotsoutput = document.querySelector(".slider.screenshots > label:last-child > .imageblock");

    iconinput.onchange = async function () {
        
      iconoutput.style.backgroundImage = "";
    
      iconoutput.style.backgroundImage = `url(${URL.createObjectURL(this.files[0])})`;
    }

    screenshotsinput.onchange = async function () {

      for (let child of [...screenshotsoutput.children]) {
        child.remove();
      }

      let files = [...this.files];

      if (files.length > 8) files.length = 8;

      for (let file of files) {
        let img = await getImage(file);
        if (img) {
          screenshotsoutput.append(img);
        }
      }
    }

    async function getImage(file) {
      return new Promise((resolve) => {
        let img = new Image();
        img.onload = function () {
          resolve(img);
        };
        img.onerror = function () {
          resolve(false);
        };
        img.src = URL.createObjectURL(file);
      });

    }

    reviewscount.onchange = function () {
      showReviews(this.value);
    }

    document.body.onload = function () {
      showReviews(reviewscount.value);
    }

    function showReviews(amount) {
      const reviews = [...document.querySelectorAll(".review")];
      for (let i = 0; i < reviews.length; i++) {
        reviews[i].style.display = i < amount ? "flex" : "none";
      }
    }

    function confirmExit() {
      return "You have attempted to leave this page. Are you sure?";
    }

    save.onclick = async function () {
      save.disabled = true;
      window.onbeforeunload = confirmExit;

      let formData = new FormData();
      formData.append(\'link\', link.value);
      formData.append(\'title\', title.value);
      formData.append(\'subtitle\', subtitle.value);
      formData.append(\'shortdescription\', shortdescription.value);
      formData.append(\'description\', description.value);
      formData.append(\'updatetext\', updatetext.value);
      formData.append(\'translatetexts\', translatetexts.checked);
      formData.append(\'translatetitle\', translatetitle.checked);
      formData.append(\'translatedevelopername\', translatedevelopername.checked);
      formData.append(\'translatereviewsnames\', translatereviewsnames.checked);
      formData.append(\'icon\', document.querySelector("input[name=iconimage]:checked").value);
      formData.append(\'iconfile\', iconinput.files[0]);
      formData.append(\'screenshots\', document.querySelector("input[name=screenshotsimage]:checked").value);
      for (let i = 0; i < 8; i++) {
        formData.append("screenshotsfiles[]", screenshotsinput.files[i]);
      }
      formData.append(\'video\', video.value);
      formData.append(\'category\', category.value);
      formData.append(\'developername\', developername.value);
      formData.append(\'installscount\', installscount.value);
      formData.append(\'agebasedrating\', agebasedrating.value);
      formData.append(\'averagerating\', averagerating.value);
      formData.append(\'ratingscount\', ratingscount.value);
      formData.append(\'reviewscount\', reviewscount.value);
      formData.append(\'reviews\', JSON.stringify(reviews.map(e => Object({
        "name": e.name.value,
        "grade": e.grade.value,
        "title": e.title.value,
        "text": e.text.value
      }))));
      formData.append(\'headcode\', headcode.value);
      formData.append(\'bodycode\', bodycode.value);
      formData.append(\'onesignalappid\', onesignalappid.value);
      formData.append(\'mode\', mode.value);
      formData.append(\'filter_level\', filter_level.value);
      formData.append(\'countrieslist\', JSON.stringify(countries.value()));
      formData.append(\'oslist\', JSON.stringify(os.value()));
      formData.append(\'browserslist\', JSON.stringify(browsers.value()));
      formData.append(\'enable_fp\', enable_fp.checked);
      formData.append(\'enable_ua\', enable_ua.checked);
      formData.append(\'require_unique\', require_unique.checked);
      formData.append(\'require_touch\', require_touch.checked);
      formData.append(\'allow_apps\', allow_apps.checked);
      formData.append(\'tz_match_ip\', tz_match_ip.checked);
      formData.append(\'skipClicks\', skipClicks.value);
      formData.append(\'skip_clicks_mode\', skip_clicks_mode.value);
      formData.append(\'product\', product.value);
      formData.append(\'target\', target.value());
      formData.append(\'lang\', lang.value);
      formData.append(\'keywords\', keywords.value);
      formData.append(\'seed\', seed.value);

      try {
        let response = await fetch(location.pathname, {
          method: \'POST\',
          body: formData
        });

        let result = await response.json();

        addNotification(result.message);
      } catch (error) {
        console.log(error);
        addNotification(error);
      }

      window.onbeforeunload = null;
      save.disabled = false;
    }

    document.addEventListener("click", function (e) {
      for (let a of [...document.querySelectorAll(".autocomplete")]) {
        if (!a.contains(e.target) && document.contains(e.target)) {
          const list = a.querySelector(".autocomplete-items");
          if (list != null) {
            list.classList.add("hidden");
          }
        }
      }
    });

    function anchorAlign(lists) {
      for (let list of lists) {
        list.style.bottom = "auto";
        list.style.top = "100%";
        if (list.getBoundingClientRect().bottom > window.innerHeight) {
          list.style.bottom = "100%";
          list.style.top = "auto";
        }
      }
    }

    window.onresize = () => {
      anchorAlign(document.querySelectorAll("div.autocomplete-items:not(.hidden)"));
    };

    function createTextField(
      labelText = null,
      value = "",
      options = [],
      multiple = false,
      disabled = false,
      type = "text",
      div = null
    ) {

      let isDisabled = disabled;

      let currentFocus = -1;

      function addActive(x) {
        if (!x || x.length <= 0) return false;
        for (let i = 0; i < x.length; i++) {
          x[i].classList.remove("autocomplete-active");
        }
        if (currentFocus >= x.length) currentFocus = 0;
        if (currentFocus < 0) currentFocus = x.length - 1;
        x[currentFocus].classList.add("autocomplete-active");
        x[currentFocus].scrollIntoView({
          behavior: "instant",
          block: "nearest",
          inline: "nearest"
        });
      }

      function updateCheckAllButton(list) {
        const isAllChecked = [
          ...list.querySelectorAll(`div.item:not(.hidden) > input[type="checkbox"]`)
        ].every((e) => e.checked);
        const button = list.querySelector(`div.checkall`);
        if (button) {
          if (isAllChecked) {
            button.innerText = `Uncheck all`;
          } else {
            button.innerText = `Check all`;
          }
        }
      }

      function showCheckedOpts(list, opts, input) {
        let checkedItems = [];
        for (let item of list.querySelectorAll(`div.item:not(.hidden)`)) {
          if (item.querySelector(`input[type="checkbox"]`).checked) {
            checkedItems.push(item.innerText);
          }
        }
        let characterLimit = 250;
        if (opts.classList.contains("show-all")) {
          characterLimit = Number.POSITIVE_INFINITY;
        }
        const shrinkedCheckedItems = checkedItems.reduce(
          (a, b) => ([...a, b].join(", ").length > characterLimit ? a : [...a, b]),
          []
        );
        for (let span of opts.querySelectorAll("span")) {
          span.remove();
        }
        for (let item of shrinkedCheckedItems) {
          let span = document.createElement("span");
          span.innerText = item;
          span.onclick = () => {
            if (!isDisabled) {
              opts.classList.toggle("show-all");
              showCheckedOpts(list, opts, input);
            }
          }
          opts.insertBefore(span, input);
        }
        if (checkedItems.length > shrinkedCheckedItems.length) {
          let span = document.createElement("span");
          span.innerText = `(+${checkedItems.length - shrinkedCheckedItems.length
            })`;
          span.onclick = () => {
            if (!isDisabled) {
              opts.classList.toggle("show-all");
              showCheckedOpts(list, opts, input);
            }
          }
          opts.insertBefore(span, input);
        }
      }

      if (div == null) {
        div = document.createElement("div");
      }
      div.classList.add("group");
      if (options.length > 0) {
        div.classList.add("autocomplete");
      }
      if (multiple) {
        div.classList.add("multiselect");
      }
      div.onclick = () => {
        [
          ...div.querySelectorAll("div.opts > textarea"),
          ...div.querySelectorAll("div.opts > input")
        ][0].focus();
      };

      let opts = document.createElement("div");
      opts.classList.add("opts");

      let input;
      if (options.length > 0 || type != "text") {
        input = document.createElement("input");
        input.type = type;
        input.value = value;
      } else {
        input = document.createElement("textarea");
        input.value = value;
        input.rows = 1;
        input.oninput = () => {
          input.style.height = `1px`;
          input.style.height = `${input.scrollHeight}px`;
        };
      }
      input.required = true;
      opts.appendChild(input);

      if (options.length > 0) {
        let list = document.createElement("div");
        list.classList.add("autocomplete-items");
        for (let option of options) {
          let optionDiv = document.createElement("div");
          optionDiv.classList.add("item");
          // optionDiv.classList.add("block");
          let optionInput = document.createElement("input");
          optionInput.required = true;
          if (multiple) {
            optionInput.type = "checkbox";
          } else {
            optionInput.type = "hidden";
          }
          optionInput.value = option.name;
          let optionLabel = document.createTextNode(option.name);
          optionDiv.appendChild(optionInput);
          optionDiv.appendChild(optionLabel);
          optionDiv.onclick = (event) => {
            event.stopPropagation();
            if (event.target.type === "checkbox") {
              event.target.checked = !event.target.checked;
            }
            if (!isDisabled) {
              if (multiple) {
                optionInput.checked = !optionInput.checked;
                showCheckedOpts(list, opts, input);
                updateCheckAllButton(list);
              } else {
                input.value = option.name;
                list.classList.add("hidden");
              }
            }
          };
          list.appendChild(optionDiv);
          if (option.checked) {
            optionDiv.click();
          }
        }
        if (multiple) {
          let checkAllDiv = document.createElement("div");
          // checkAllDiv.classList.add("block");
          checkAllDiv.classList.add("checkall");
          checkAllDiv.addEventListener("click", function (el) {
            const isAllChecked = [
              ...list.querySelectorAll(`div.item:not(.hidden) > input[type="checkbox"]`)
            ].every((e) => e.checked);
            for (let item of list.querySelectorAll(`div.item:not(.hidden)`)) {
              if (
                isAllChecked == true ||
                (isAllChecked == false &&
                  item.querySelector(`input[type="checkbox"]`).checked == false)
              ) {
                item.click();
              }
            }
          });
          list.insertAdjacentElement("afterbegin", checkAllDiv);
          updateCheckAllButton(list);
        }

        list.classList.add("hidden");
        opts.appendChild(list);

        input.addEventListener("keydown", function (event) {
          const x = list.querySelectorAll("div:not(.hidden)");
          switch (event.key) {
            case "ArrowDown":
              currentFocus++;
              addActive(x);
              return;
            case "ArrowUp":
              currentFocus--;
              addActive(x);
              return;
            case "Enter":
              if (currentFocus > -1 && x && !isDisabled) {
                x[currentFocus].click();
              }
              return;
            case "Tab":
            case "Escape":
              list.classList.add("hidden");
              return;
            case "Backspace":
              if (
                multiple &&
                input.selectionStart == 0 &&
                input.selectionEnd == 0 &&
                !isDisabled
              ) {
                let checkedList = list.querySelectorAll(
                  "input[type=checkbox]:checked"
                );
                if (checkedList.length != 0) {
                  checkedList[checkedList.length - 1].click();
                }
              }
              return;
            default:
              addActive(x);
          }
        });

        input.addEventListener("focus", function (event) {
          list.classList.remove("hidden");
          anchorAlign([list]);
        });

        input.addEventListener("input", function (event) {
          list.classList.remove("hidden");
          let keys = input.value.toLowerCase().match(/\S+/g);
          if (keys == null) {
            keys = [""];
          }
          if (keys.length > 1 && keys.every((elem) => { return elem.length == 2; })) {
            for (let item of list.querySelectorAll(".item")) {
              for (let key of keys) {
                if (item.innerText.toLowerCase().slice(1, 3) == key) {
                  // item.classList.add("block");
                  item.classList.remove("hidden");
                  break;
                } else {
                  item.classList.add("hidden");
                  // item.classList.remove("block");
                }
              }
            }
          } else {
            for (let item of list.querySelectorAll(".item")) {
              for (let key of keys) {
                if (item.innerText.toLowerCase().includes(key)) {
                  // item.classList.add("block");
                  item.classList.remove("hidden");
                  break;
                } else {
                  item.classList.add("hidden");
                  // item.classList.remove("block");
                }
              }
            }
          }
          currentFocus = +multiple;
          addActive(list.querySelectorAll("div"));
          anchorAlign([list]);
          updateCheckAllButton(list);
        });
      }

      div.appendChild(opts);

      if (labelText) {
        let label = document.createElement("label");
        label.innerText = labelText;
        div.appendChild(label);
      }

      div.value = () => {
        if (multiple) {
          return [
            ...div.querySelectorAll(".opts > .autocomplete-items > .item")
          ].map((e) =>
            Object({
              name: e.querySelector("input").value,
              checked: e.querySelector("input").checked
            })
          );
        }
        if (options.length > 0 || type != "text") {
          // return [...div.querySelectorAll(".opts > .autocomplete-items > .item")].map(e => Object({"name": e.querySelector("input").value, "checked": e.querySelector("input").value === div.querySelector(".opts > input[type=text]").value}));
          return div.querySelector(".opts > input").value;
        }
        return div.querySelector(".opts > textarea").value;
      };

      div.setValue = (e) => {
        if (options.length > 0) {
          div.querySelector(".opts > input").value = e;
          return true;
        }
        div.querySelector(".opts > textarea").value = e;
      };

      div.setDisabled = (e) => {
        isDisabled = e;
        if (options.length < 1) {
          input.disabled = isDisabled;
        }
      };

      return div;
    }';

$countrylist = array();
if (!empty($configData["countrieslist"])) {
    $countrylist = json_decode($configData["countrieslist"]);
}
if (!$countrylist) {
    $countrylist = array_map(function ($e) {
        return array(
            "name" => $e,
            "checked" => false
        );
    }, [
        "[AD] Andorra",
        "[AE] United Arab Emirates",
        "[AF] Afghanistan",
        "[AG] Antigua and Barbuda",
        "[AI] Anguilla",
        "[AL] Albania",
        "[AM] Armenia",
        "[AO] Angola",
        "[AQ] Antarctica",
        "[AR] Argentina",
        "[AS] American Samoa",
        "[AT] Austria",
        "[AU] Australia",
        "[AW] Aruba",
        "[AX] Åland Islands",
        "[AZ] Azerbaijan",
        "[BA] Bosnia and Herzegovina",
        "[BB] Barbados",
        "[BD] Bangladesh",
        "[BE] Belgium",
        "[BF] Burkina Faso",
        "[BG] Bulgaria",
        "[BH] Bahrain",
        "[BI] Burundi",
        "[BJ] Benin",
        "[BL] Saint Barthélemy",
        "[BM] Bermuda",
        "[BN] Brunei Darussalam",
        "[BO] Bolivia (Plurinational State of)",
        "[BQ] Bonaire, Sint Eustatius and Saba",
        "[BR] Brazil",
        "[BS] Bahamas",
        "[BT] Bhutan",
        "[BV] Bouvet Island",
        "[BW] Botswana",
        "[BY] Belarus",
        "[BZ] Belize",
        "[CA] Canada",
        "[CC] Cocos (Keeling) Islands",
        "[CD] Congo, Democratic Republic of the",
        "[CF] Central African Republic",
        "[CG] Congo",
        "[CH] Switzerland",
        "[CI] Côte d\'Ivoire",
        "[CK] Cook Islands",
        "[CL] Chile",
        "[CM] Cameroon",
        "[CN] China",
        "[CO] Colombia",
        "[CR] Costa Rica",
        "[CU] Cuba",
        "[CV] Cabo Verde",
        "[CW] Curaçao",
        "[CX] Christmas Island",
        "[CY] Cyprus",
        "[CZ] Czechia",
        "[DE] Germany",
        "[DJ] Djibouti",
        "[DK] Denmark",
        "[DM] Dominica",
        "[DO] Dominican Republic",
        "[DZ] Algeria",
        "[EC] Ecuador",
        "[EE] Estonia",
        "[EG] Egypt",
        "[EH] Western Sahara",
        "[ER] Eritrea",
        "[ES] Spain",
        "[ET] Ethiopia",
        "[FI] Finland",
        "[FJ] Fiji",
        "[FK] Falkland Islands (Malvinas)",
        "[FM] Micronesia (Federated States of)",
        "[FO] Faroe Islands",
        "[FR] France",
        "[GA] Gabon",
        "[GB] United Kingdom of Great Britain and Northern Ireland",
        "[GD] Grenada",
        "[GE] Georgia",
        "[GF] French Guiana",
        "[GG] Guernsey",
        "[GH] Ghana",
        "[GI] Gibraltar",
        "[GL] Greenland",
        "[GM] Gambia",
        "[GN] Guinea",
        "[GP] Guadeloupe",
        "[GQ] Equatorial Guinea",
        "[GR] Greece",
        "[GS] South Georgia and the South Sandwich Islands",
        "[GT] Guatemala",
        "[GU] Guam",
        "[GW] Guinea-Bissau",
        "[GY] Guyana",
        "[HK] Hong Kong",
        "[HM] Heard Island and McDonald Islands",
        "[HN] Honduras",
        "[HR] Croatia",
        "[HT] Haiti",
        "[HU] Hungary",
        "[ID] Indonesia",
        "[IE] Ireland",
        "[IL] Israel",
        "[IM] Isle of Man",
        "[IN] India",
        "[IO] British Indian Ocean Territory",
        "[IQ] Iraq",
        "[IR] Iran (Islamic Republic of)",
        "[IS] Iceland",
        "[IT] Italy",
        "[JE] Jersey",
        "[JM] Jamaica",
        "[JO] Jordan",
        "[JP] Japan",
        "[KE] Kenya",
        "[KG] Kyrgyzstan",
        "[KH] Cambodia",
        "[KI] Kiribati",
        "[KM] Comoros",
        "[KN] Saint Kitts and Nevis",
        "[KP] Korea (Democratic People\'s Republic of)",
        "[KR] Korea, Republic of",
        "[KW] Kuwait",
        "[KY] Cayman Islands",
        "[KZ] Kazakhstan",
        "[LA] Lao People\'s Democratic Republic",
        "[LB] Lebanon",
        "[LC] Saint Lucia",
        "[LI] Liechtenstein",
        "[LK] Sri Lanka",
        "[LR] Liberia",
        "[LS] Lesotho",
        "[LT] Lithuania",
        "[LU] Luxembourg",
        "[LV] Latvia",
        "[LY] Libya",
        "[MA] Morocco",
        "[MC] Monaco",
        "[MD] Moldova, Republic of",
        "[ME] Montenegro",
        "[MF] Saint Martin (French part)",
        "[MG] Madagascar",
        "[MH] Marshall Islands",
        "[MK] North Macedonia",
        "[ML] Mali",
        "[MM] Myanmar",
        "[MN] Mongolia",
        "[MO] Macao",
        "[MP] Northern Mariana Islands",
        "[MQ] Martinique",
        "[MR] Mauritania",
        "[MS] Montserrat",
        "[MT] Malta",
        "[MU] Mauritius",
        "[MV] Maldives",
        "[MW] Malawi",
        "[MX] Mexico",
        "[MY] Malaysia",
        "[MZ] Mozambique",
        "[NA] Namibia",
        "[NC] New Caledonia",
        "[NE] Niger",
        "[NF] Norfolk Island",
        "[NG] Nigeria",
        "[NI] Nicaragua",
        "[NL] Netherlands, Kingdom of the",
        "[NO] Norway",
        "[NP] Nepal",
        "[NR] Nauru",
        "[NU] Niue",
        "[NZ] New Zealand",
        "[OM] Oman",
        "[PA] Panama",
        "[PE] Peru",
        "[PF] French Polynesia",
        "[PG] Papua New Guinea",
        "[PH] Philippines",
        "[PK] Pakistan",
        "[PL] Poland",
        "[PM] Saint Pierre and Miquelon",
        "[PN] Pitcairn",
        "[PR] Puerto Rico",
        "[PS] Palestine, State of",
        "[PT] Portugal",
        "[PW] Palau",
        "[PY] Paraguay",
        "[QA] Qatar",
        "[RE] Réunion",
        "[RO] Romania",
        "[RS] Serbia",
        "[RU] Russian Federation",
        "[RW] Rwanda",
        "[SA] Saudi Arabia",
        "[SB] Solomon Islands",
        "[SC] Seychelles",
        "[SD] Sudan",
        "[SE] Sweden",
        "[SG] Singapore",
        "[SH] Saint Helena, Ascension and Tristan da Cunha",
        "[SI] Slovenia",
        "[SJ] Svalbard and Jan Mayen",
        "[SK] Slovakia",
        "[SL] Sierra Leone",
        "[SM] San Marino",
        "[SN] Senegal",
        "[SO] Somalia",
        "[SR] Suriname",
        "[SS] South Sudan",
        "[ST] Sao Tome and Principe",
        "[SV] El Salvador",
        "[SX] Sint Maarten (Dutch part)",
        "[SY] Syrian Arab Republic",
        "[SZ] Eswatini",
        "[TC] Turks and Caicos Islands",
        "[TD] Chad",
        "[TF] French Southern Territories",
        "[TG] Togo",
        "[TH] Thailand",
        "[TJ] Tajikistan",
        "[TK] Tokelau",
        "[TL] Timor-Leste",
        "[TM] Turkmenistan",
        "[TN] Tunisia",
        "[TO] Tonga",
        "[TR] Türkiye",
        "[TT] Trinidad and Tobago",
        "[TV] Tuvalu",
        "[TW] Taiwan, Province of China",
        "[TZ] Tanzania, United Republic of",
        "[UA] Ukraine",
        "[UG] Uganda",
        "[UM] United States Minor Outlying Islands",
        "[US] United States of America",
        "[UY] Uruguay",
        "[UZ] Uzbekistan",
        "[VA] Holy See",
        "[VC] Saint Vincent and the Grenadines",
        "[VE] Venezuela (Bolivarian Republic of)",
        "[VG] Virgin Islands (British)",
        "[VI] Virgin Islands (U.S.)",
        "[VN] Viet Nam",
        "[VU] Vanuatu",
        "[WF] Wallis and Futuna",
        "[WS] Samoa",
        "[YE] Yemen",
        "[YT] Mayotte",
        "[ZA] South Africa",
        "[ZM] Zambia",
        "[ZW] Zimbabwe"
    ]);
}

$oslist = array();
if (!empty($configData["oslist"])) {
    $oslist = json_decode($configData["oslist"]);
}
if (!$oslist) {
    $oslist = array_map(function ($e) {
        return array(
            "name" => $e,
            "checked" => false
        );
    }, [
      "Android 1",
      "Android 2",
      "Android 3",
      "Android 4",
      "Android 5",
      "Android 6",
      "Android 7",
      "Android 8",
      "Android 9",
      "Android 10",
      "Android 11",
      "Android 12",
      "Android 13",
      "Android 14",
      "iOS",
      "KaiOS",
      "macOS",
      "Linux",
      "Other",
      "Windows XP",
      "Windows Vista",
      "Windows 7",
      "Windows 8",
      "Windows 8.1",
      "Windows 10",
      "Windows Other"
    ]);
}

$browserslist = array();
if (!empty($configData["browserslist"])) {
    $browserslist = json_decode($configData["browserslist"]);
}
if (!$browserslist) {
    $browserslist = array_map(function ($e) {
        return array(
            "name" => $e,
            "checked" => false
        );
    }, [
      "Apple Safari",
      "Facebook app",
      "Google Chrome",
      "Internet Explorer",
      "Microsoft Edge",
      "Mozilla Firefox",
      "Opera",
      "Other",
      "Samsung Internet",
      "Snapchat app",
      "UC Browser",
      "WebView",
      "Yandex Browser"
    ]);
}

echo 'const targetList = [
      "beauty",
      "travel",
      "music",
      "food",
      "science",
      "gaming",
      "energy",
      "news",
      "sport",
      "tech",
      "world",
      "finance",
      "politics",
      "business",
      "economics",
      "entertainment"
    ];';
    
echo 'const countryList = ' . json_encode($countrylist) . ';';    
echo 'const osList = ' . json_encode($oslist) . ';';    
echo 'const browsersList = ' . json_encode($browserslist) . ';';  

echo 'createTextField(
      null,
      "",
      countryList,
      true,
      false,
      false,
      countries
    );

    createTextField(
      null,
      "",
      osList,
      true,
      false,
      false,
      os
    );

    createTextField(
      null,
      "",
      browsersList,
      true,
      false,
      false,
      browsers
    );

    createTextField(
      null,
      "' . htmlspecialchars($configData['target'] ?? '') . '",
      targetList.map((e) => Object({
        name: e,
        checked: false
      })),
      false,
      false,
      false,
      target
    );

    function saveLinks(linksList) {
      const req = Object({
        time: Date.now(),
        data: linksList.map((e) => {
          return Object({
            host: e.querySelector(".host").value(),
            parameters: e.querySelector(".parameters").value(),
            comment: e.querySelector(".comment").value(),
            filters: [...e.querySelectorAll(".filter")].map((i) => {
              return Object({
                name: i.querySelector("label").innerText,
                value: Array.isArray(i.value()) ? "" : i.value(),
                options: Array.isArray(i.value()) ? i.value() : [],
                multiple: true
              });
            })
          });
        })
      });
      fetch("", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify(req)
      })
        .then((res) => {
          if (res.ok) {
            console.log(`Saved successfully: ${res}`);
            addNotification(`Saved successfully`);
          } else {
            throw new Error("Something went wrong");
          }
        })
        .catch((error) => {
          console.log(error);
          addNotification(error);
        });
    }

    generate.onclick = async () => {
      generate.disabled = true;
      for (let child of [...output.children]) {
        child.remove();
      }
      seed.value = crypto.randomUUID();

      try {
        let response = await fetch(`/generatepreview.php?product=${encodeURIComponent(product.value)}&target=${encodeURIComponent(target.value())}&lang=${encodeURIComponent(lang.value)}&keywords=${encodeURIComponent(keywords.value)}&seed=${encodeURIComponent(seed.value)}&domain=${encodeURIComponent(location.host)}`, {
          method: "GET",
        });

        if (response) {
          let blob = await response.blob();
          if (blob) {
            let img = document.createElement("img");
            img.src = URL.createObjectURL(blob);
            img.onerror = function () {
              img.title = "Проверьте параметры вашей генерации и, если все верно, попробуйте сгенерировать вайт повторно, повторная генерация должна пройти успешно. При получении данной ошибки более двух раз подряд следует изменить тему и попробовать снова."
            }
            output.append(img);
            img.scrollIntoView({
              behavior: "smooth",
              block: "start",
              inline: "start"
            });
          }
        }
      } catch (e) {
        console.log(e);
      }

      generate.disabled = false;
    };

    function addNotification(text) {
      text = text.toString();
      const s = Math.min(Math.max(text.length / 5, 4), 20);
      let n = document.createElement("span");
      n.style.animation = `fade-out 1.1s ease ${(s - 1)}s`;
      n.innerText = text;
      document.querySelector("#notifications").appendChild(n);
      setTimeout(function () {
        n.remove();
      }, s * 1000);
    }

    function addDialogBackdropClickEventListener(dialog, callback = null) {
      dialog.addEventListener("click", function (event) {
        const rect = dialog.getBoundingClientRect();
        if (
          !(
            rect.top <= event.clientY &&
            event.clientY <= rect.top + rect.height &&
            rect.left <= event.clientX &&
            event.clientX <= rect.left + rect.width
          )
        ) {
          dialog.close();
          if (callback) {
            callback();
          }
        }
      }, {
        \'capture\': true
      });
    }

    addDialogBackdropClickEventListener(document.querySelector(\'dialog\'));
  </script>
</body>

</html>';

?>